# SMIT Development Standards

This repository contains AI assistant configuration, coding standards, and development rules for SMIT platform enterprise software development. The repository is organized into two main segments: AI assistant prompts and technical rules for automated code generation and validation.

## 🗂️ Repository Structure

### 1. 📝 Prompts

AI assistant prompts for generating specific documents and validating content

- **Purpose**: Templates and instructions for AI to generate or validate documents
- **Target**: AI assistants, content generators, document validators
- **Location**: `prompts/` directory

### 2. 🤖 Rules

Technical rules and requirements for AI coding in Cursor format (compatible with any AI assistant)

- **Purpose**: Automatically enforceable coding standards and technical patterns
- **Target**: Software developers, AI coding assistants, automated code review tools
- **Location**: `rules/` directory

## 📚 Documentation

**Note**: Developer documentation has been moved to the dedicated [IDP Documentation Repository](https://github.com/company/idp-docs) for better organization and Confluence integration.

The IDP repository contains:

- Technical requirements and standards
- Integration requirements
- Logging and monitoring guidelines
- Platform services documentation
- Development workflows and processes

## 🚀 Getting Started

### 1. 🤖 Review Global AI-Enforceable Rules

| # | Rule | Description | Rules Count |
|---|------|-------------|-------------|
| 1 | [`rules/common/component-technical-standards.mdc`](rules/common/component-technical-standards.mdc) | Core development standards | 42 rules |
| 2 | [`rules/common/integration-standards.mdc`](rules/common/integration-standards.mdc) | API and message queue patterns | 15 rules |
| 3 | [`rules/common/security.mdc`](rules/common/security.mdc) | Security implementation patterns | - |

### 2. 🔧 Review Framework-Specific Rules

| # | Framework | Description | Focus |
|---|-----------|-------------|-------|
| 1 | [`rules/java-common/`](rules/java-common/) | Java coding standards, logging, and database access | Backend |
| 2 | [`rules/java-spring-boot/`](rules/java-spring-boot/) | Spring conventions, retry patterns, and testing | Backend |
| 3 | [`rules/java-micronaut/`](rules/java-micronaut/) | Micronaut retry conventions | Backend |
| 4 | [`rules/typescript-common/`](rules/typescript-common/) | TypeScript code standards, application logging, and audit logging | Frontend |
| 5 | [`rules/typescript-vue/`](rules/typescript-vue/) | Vue 3 conventions with Composition API and modern best practices | Frontend |
| 6 | [`rules/typescript-angular/`](rules/typescript-angular/) | Angular conventions with signals, standalone components, and modern patterns | Frontend |

### 3. ⚙️ Setup and Tools

| # | Tool | Description | Purpose |
|---|------|-------------|---------|
| 1 | [Setup Instructions](#️-setup-instructions) | Follow the setup instructions below | Enable automated enforcement |
| 2 | [`prompts/code-review-mode.md`](prompts/code-review-mode.md) | Structured code review process for AI assistants | Code review |
| 3 | [`prompts/component-architecture-generator.md`](prompts/component-architecture-generator.md) | Generate software component architectures | Architecture |
| 4 | [`prompts/readme-generator.md`](prompts/readme-generator.md) | Generate project README files | Documentation |
| 5 | [`prompts/estonian-language-rules.md`](prompts/estonian-language-rules.md) | Estonian language guidelines for content | Localization |
| 6 | [`prompts/cursor-system-prompt.md`](prompts/cursor-system-prompt.md) | Main system prompt for Cursor AI assistant | Configuration |

### 4. 📖 AI Tools (Optional)

| # | Tool | Description | Purpose |
|---|------|-------------|---------|
| 1 | [`rules/ai-tools/rules-guide.mdc`](rules/ai-tools/rules-guide.mdc) | How to write effective AI rules | Rule creation |
| 2 | [`rules/ai-tools/md-guide.mdc`](rules/ai-tools/md-guide.mdc) | Markdown formatting standards | Documentation |
| 3 | [`rules/ai-tools/project-context.mdc`](rules/ai-tools/project-context.mdc) | Project context management | Context tracking |
| 4 | [`rules/ai-tools/tasklist.mdc`](rules/ai-tools/tasklist.mdc) | Task organization and tracking | Task management |
| 5 | [`rules/ai-tools/agent-memory.mdc`](rules/ai-tools/agent-memory.mdc) | AI assistant memory optimization | Memory management |

## 📊 Standards Summary

- **AI-Enforceable Rules**: 57+ across all frameworks
  - **Component Standards**: 42 rules
  - **Integration Standards**: 15 rules
  - **Framework-Specific**: 100+ rules across Java, TypeScript, Vue, Angular
- **Coverage**: Complete enterprise software development lifecycle
- **Platform**: SMIT hosting platform optimized
- **Languages**: Multi-language support (Java, TypeScript, Vue, Angular, etc.)

## ⚙️ Setup Instructions

### Applying the System Prompt in Cursor

1. Open Cursor settings (`Cmd + ,` on macOS)
2. Navigate to Cursor -> Settings -> Cursor setting -> Rules
3. Copy the entire content of [`prompts/cursor-system-prompt.md`](prompts/cursor-system-prompt.md)
4. Paste it into the 'Edit User Rules' text area

### Centralized Rule Management with Symbolic Links

For managing rules across multiple projects:

1. **Clone this repository** to a stable location:

   ```bash
   git clone https://source.smit.sise/scm/idp/smit-development-standards.git
   ```

2. **Link rules to your projects**:

   ```bash
   # In your project root
   mkdir .cursor/rules
   ln -s <path-to-clone>/smit-development-standards/rules/common .cursor/rules/common
   ln -s <path-to-clone>/smit-development-standards/rules/java-spring-boot .cursor/rules/spring-boot
   ```

   **Note**: Link every folder you want to use in your project. This way you don't need to copy files - Cursor will automatically pick up all rules from the linked folders. You can also link folders containing documentation, prompts, or other data you want to include in your Cursor project context.

3. **Add to .gitignore**:

   ```gitignore
   .cursor/rules
   ```

### Framework-Specific Setup

- **Spring Boot**: Link `common` + `java-common` + `java-spring-boot`
- **Micronaut**: Link `common` + `java-common` + `java-micronaut`
- **Vue Applications**: Link `common` + `typescript-common` + `typescript-vue`
- **Angular Applications**: Link `common` + `typescript-common` + `typescript-angular`
- **TypeScript Projects**: Link `common` + `typescript-common`
- **Other frameworks**: Link `common` + appropriate technology-specific rules

### Using Code Review Mode

1. Open the [`prompts/code-review-mode.md`](prompts/code-review-mode.md) file
2. Copy the content and use it as a prompt for AI-assisted code reviews
3. Follow the structured review process for comprehensive code analysis

## 🔄 Repository Organization

### Current Structure

```bash
smit-development-standards/
├── prompts/                    # AI assistant prompts
│   ├── cursor-system-prompt.md
│   ├── code-review-mode.md
│   ├── component-architecture-generator.md
│   ├── readme-generator.md
│   └── estonian-language-rules.md
├── rules/                      # Technical coding rules
│   ├── common/                 # Global standards
│   ├── java-common/           # Java standards
│   ├── java-spring-boot/      # Spring Boot conventions
│   ├── java-micronaut/        # Micronaut conventions
│   ├── typescript-common/     # TypeScript standards
│   ├── typescript-vue/        # Vue.js conventions
│   ├── typescript-angular/    # Angular conventions
│   └── ai-tools/              # AI assistant tools
└── README.md                   # This file
```

## 👨‍💻 Author

**Name:** [Mart Järvi]  
**Email:** [mart.jarvi@smit.sise]

---

*This repository contains enterprise software development standards for the SMIT platform.*
